CONTAINER OEditGuidesModifier
{
	NAME OEditGuidesModifier;
	INCLUDE Obase;
	
	GROUP ID_OBJECTPROPERTIES
	{
		LONG edg_EditModeAttribute
		{
			HIDDEN;
			CYCLE
			{
				edg_EditMode_None;
				edg_EditMode_Root;
				edg_EditMode_Strand;
				edg_EditMode_Brush;
			};
		}
		
		GROUP
		{
			COLUMNS 3;
			
			BITMAPBUTTON edg_Button_EditMode_Root { OPEN; NAME edg_EditModeAttribute; }
			BITMAPBUTTON edg_Button_EditMode_Strand { OPEN; }
			BITMAPBUTTON edg_Button_EditMode_Brush { OPEN; }
		}
		
		SEPARATOR { LINE; }
		
		GROUP
		{
			COLUMNS 4;
			
			BUTTON edg_Button_SelectStrandsTool {}
			BUTTON edg_Button_SelectStrandsRectTool {}
			BUTTON edg_Button_SelectStrandsAll {}
			BUTTON edg_Button_SelectStrandsNone {}
			BUTTON edg_Button_MoveStrands {}
			BUTTON edg_Button_ScaleStrands {}
			BUTTON edg_Button_RotateStrands {}
			BUTTON edg_Button_DeleteStrands {}
		}
		
		LONG edg_SelectStrandsRadius
		{
			CUSTOMGUI LONGSLIDER;
			MIN 1;
			MAX 100;
			ANIM OFF;
		}
		
		LONG edg_SelectedStrandsCount
		{
			ANIM OFF;
			STEP 0;
		}
		
		BOOL edg_SkipHairUpdateWhileDragging
		{
			ANIM OFF;
		}
		
		VECTOR edg_TransformScale
		{
			// UNIT METER will link to the scale tool
			UNIT METER;
			STEP 0.001;
			HIDDEN;
		}

		SEPARATOR { LINE; }
		
		GROUP edg_Apply_Group
		{
			DEFAULT 1;
			
			REAL edg_ApplyAmountAttribute
			{
				CUSTOMGUI REALSLIDER;
				UNIT PERCENT;
				MIN 0.0;
				MAX 100.0;
			}
			
			SPLINE edg_ApplyRampAttribute { }
			
			SHADERLINK edg_ApplyMultiplierAttribute { }
			
			LONG edg_ApplyChannelAttribute
			{
				MIN 0;
				ANIM OFF;
			}
			
			// TODO: Uncomment when multi-resolution GuidesDelta is finished
			// SEPARATOR { LINE; }
			// BUTTON edg_Button_MultiResolutionToggle {}
		}
		
		// Guide Options
		
		GROUP edg_GuideOptions_Group
		{
			DEFAULT 1;
			
			GROUP
			{
				COLUMNS 2;
				
				BOOL edg_IgnoreBackfacingStrandSelectionAttribute { ANIM OFF ; }
				BOOL edg_ShowColorGuidesAttribute { ANIM OFF ; }
				
				BOOL edg_ShowVertexTicksAttribute { ANIM OFF ; }
				BOOL edg_HideGuidesAttribute { ANIM OFF ; }
			}
			
			REAL edg_GuidesWidthAttribute
			{
				CUSTOMGUI REALSLIDER;
				MIN 1.0;
				MAX 10.0;
				STEP 0.1;
				ANIM OFF;
			}
		}
		
		// Guide Operations
		
		GROUP edg_GuideOperations_Group
		{
			DEFAULT 1;
			
			GROUP
			{
				COLUMNS 4;
				
				BUTTON edg_Button_GuideOptions_Hide {}
				BUTTON edg_Button_GuideOptions_Unhide {}
				BUTTON edg_Button_GuideOptions_Freeze {}
				BUTTON edg_Button_GuideOptions_Unfreeze {}
			}
			
			BUTTON edg_Button_GuideOptions_Delete {}
			
			SEPARATOR { LINE; }
			
			REAL edg_PushAwayFromMeshDistance
			{
				CUSTOMGUI REALSLIDER;
				MIN 0.0;
				MAX 100.0;
				STEP 0.1;
				ANIM OFF;
			}
			
			BOOL edg_PushAwayFromMeshSelectedOnly
			{
				ANIM OFF;
				HIDDEN;
			}
			
			BOOL edg_PushAwayFromMeshAuto { ANIM OFF ; }
			
			BUTTON edg_Button_GuideOptions_PushAway {}
			
			SEPARATOR { LINE; }
			
			BUTTON edg_Button_GuideOptions_AdoptFromStackTop {}
		}
		
		// Guides
		
		GROUP edg_Guides_Group
		{
			DEFAULT 1;
			
			REAL edg_ControlPointPositionAttribute
			{
				CUSTOMGUI REALSLIDER;
				MIN 0.0;
				MAX 1.0;
				STEP 0.01;
				ANIM OFF;
			}
			
			REAL edg_ControlPointInfluenceAttribute
			{
				CUSTOMGUI REALSLIDER;
				MIN 0.0;
				MAX 1.0;
				STEP 0.01;
				ANIM OFF;
			}
			
			BOOL edg_UseStrandIkAttribute { ANIM OFF ; }
			
			LONG edg_IkIterationsAttribute
			{
				CUSTOMGUI LONGSLIDER;
				MIN 1;
				//MAX 10;
				ANIM OFF;
			}
			
			GROUP
			{
				COLUMNS 2;
				BOOL edg_OptimizeStrandGeometryAttribute_CP { ANIM OFF ; }
				BOOL edg_ResampleStrandsAttribute_CP { ANIM OFF ; }
			}

			SEPARATOR { LINE; }
			
			BOOL edg_UseElasticBrushAttribute_CP
			{
				PARENTCOLLAPSE;
				ANIM OFF ;
			}
			
			REAL edg_ElasticPoissonRatioAttribute_CP
			{
				PARENTCOLLAPSE edg_UseElasticBrushAttribute_CP;
				CUSTOMGUI REALSLIDER;
				MIN -1.0;
				MAX 0.5;
				STEP 0.01;
				ANIM OFF;
			}
			
			GROUP
			{
				PARENTCOLLAPSE edg_UseElasticBrushAttribute_CP;
				
				COLUMNS 2;
				
				BOOL edg_ElasticUseRK4IntegrationAttribute_CP { ANIM OFF; }
				BOOL edg_ElasticUseMultiscaleAttribute_CP { ANIM OFF; }
				
				BOOL edg_ElasticUse2dFieldAttribute_CP { ANIM OFF; HIDDEN; }
				BOOL edg_ElasticPinchAttribute_CP { ANIM OFF; HIDDEN; }
				
				BOOL edg_ElasticIsCenterMovingAttribute_CP { ANIM OFF; HIDDEN; }
				BOOL edg_ElasticReverseSignAttribute_CP { ANIM OFF; HIDDEN; }
				
				BOOL edg_ElasticUseAffineAttribute_CP { ANIM OFF; }
			}
			
			REAL edg_ElasticDepth3dAttribute_CP
			{
				PARENTCOLLAPSE edg_UseElasticBrushAttribute_CP;
				CUSTOMGUI REALSLIDER;
				MIN -1.0;
				MAX 1.0;
				STEP 0.01;
				ANIM OFF;
				HIDDEN;
			}
		}
		
		// Roots
		
		GROUP edg_Root_Group
		{
			DEFAULT 1;

			BOOL edg_ModifyRootsAttribute { ANIM OFF ; }
			
			SEPARATOR { LINE; }
			
			BOOL edg_PlantedGuideAdoptGuide { ANIM OFF ; }
			
			REAL edg_PlantedGuideLength
			{
				CUSTOMGUI REALSLIDER;
				MIN 0.01;
				MAXSLIDER 500.0;
				STEP 0.1;
				ANIM OFF;
			}
			
			LONG edg_PlantedGuidePointCount
			{
				CUSTOMGUI LONGSLIDER;
				MIN 2;
				MAXSLIDER 1000;
				ANIM OFF;

			}
			
			BUTTON edg_Button_Roots_PlantGuide {}
		}
		
		// Brushes
		
		GROUP edg_Brush_Group
		{
			DEFAULT -1;
			
			LONG edg_BrushAttribute
			{
				HIDDEN;
				ANIM OFF;
				CYCLE
				{
					edg_BrushType_Select;
					edg_BrushType_Comb;
					edg_BrushType_Rotate;
					edg_BrushType_Scale;
					edg_BrushType_Cut;
					edg_BrushType_GrowShrink;
					edg_BrushType_Paint;
					edg_BrushType_Grab;
					edg_BrushType_Smooth;
					edg_BrushType_Revert;
					edg_BrushType_Pull;
					edg_BrushType_User;
				};
			}
			
			GROUP
			{
				COLUMNS 12;
				
				BITMAPBUTTON edg_Button_BrushType_Select { OPEN; NAME edg_BrushAttribute; }
				BITMAPBUTTON edg_Button_BrushType_Comb { OPEN; }
				BITMAPBUTTON edg_Button_BrushType_Rotate { OPEN; }
				BITMAPBUTTON edg_Button_BrushType_Scale { OPEN; }
				BITMAPBUTTON edg_Button_BrushType_Cut { OPEN; }
				BITMAPBUTTON edg_Button_BrushType_GrowShrink { OPEN; }
				BITMAPBUTTON edg_Button_BrushType_Paint { OPEN; }
				BITMAPBUTTON edg_Button_BrushType_Grab { OPEN; }
				BITMAPBUTTON edg_Button_BrushType_Smooth { OPEN; }
				BITMAPBUTTON edg_Button_BrushType_Revert { OPEN; }
				BITMAPBUTTON edg_Button_BrushType_Pull { OPEN; }
				BITMAPBUTTON edg_Button_BrushType_User { OPEN; }
			}
			
			SEPARATOR { }

			LONG edg_BrushShapeAttribute
			{
				HIDDEN;
				ANIM OFF;
				CYCLE
				{
					edg_BrushShape_Circle;
					edg_BrushShape_Rectangle;
					edg_BrushShape_Line;
				};
			}
			
			GROUP
			{
				COLUMNS 3;
				
				BITMAPBUTTON edg_Button_BrushShape_Circle { OPEN; NAME edg_BrushShapeAttribute; }
				BITMAPBUTTON edg_Button_BrushShape_Rectangle { OPEN; }
				BITMAPBUTTON edg_Button_BrushShape_Line { OPEN; }
			}
			
			SEPARATOR { LINE; }
			
			LONG edg_UserBrushAttribute { ANIM OFF; }
			
			BUTTON edg_Button_UserBrushRefresh {}
			
			SEPARATOR { LINE; }
			
			BOOL edg_UseElasticBrushAttribute
			{
				PARENTCOLLAPSE;
				ANIM OFF ;
			}

			REAL edg_ElasticPoissonRatioAttribute
			{
				PARENTCOLLAPSE edg_UseElasticBrushAttribute;
				CUSTOMGUI REALSLIDER;
				MIN -1.0;
				MAX 0.5;
				STEP 0.01;
				ANIM OFF;
			}

			GROUP
			{
				PARENTCOLLAPSE edg_UseElasticBrushAttribute;
				
				COLUMNS 2;

				BOOL edg_ElasticUseRK4IntegrationAttribute { ANIM OFF; }
				BOOL edg_ElasticUseMultiscaleAttribute { ANIM OFF; }
				
				BOOL edg_ElasticUse2dFieldAttribute { ANIM OFF; }
				BOOL edg_ElasticPinchAttribute { ANIM OFF; }
				
				BOOL edg_ElasticIsCenterMovingAttribute { ANIM OFF; }
				BOOL edg_ElasticReverseSignAttribute { ANIM OFF; }

				BOOL edg_ElasticUseAffineAttribute { ANIM OFF; HIDDEN; }
			}
			
			REAL edg_ElasticDepth3dAttribute
			{
				PARENTCOLLAPSE edg_UseElasticBrushAttribute;
				CUSTOMGUI REALSLIDER;
				MIN -1.0;
				MAX 1.0;
				STEP 0.01;
				ANIM OFF;
			}
			
			SEPARATOR { LINE; }
			
			LONG edg_BrushSizeAttribute
			{
				CUSTOMGUI LONGSLIDER;
				MIN 1;
				MAX 250;
				ANIM OFF;
			}
			
			REAL edg_BrushStrengthAttribute
			{
				CUSTOMGUI REALSLIDER;
				MIN 0.01;
				MAX 10.0;
				STEP 0.01;
				ANIM OFF;
			}
			
			REAL edg_BrushMaxLimiterAttribute
			{
				CUSTOMGUI REALSLIDER;
				MIN 0.1;
				MAXSLIDER 1000.0;
				STEP 1.0;
				ANIM OFF;
			}
			
			REAL edg_BrushMinLimiterAttribute
			{
				CUSTOMGUI REALSLIDER;
				MIN 0.0;
				MAXSLIDER 100.0;
				STEP 1.0;
				ANIM OFF;
			}
			
			GROUP
			{
				COLUMNS 2;
				
				BOOL edg_UseSurfaceBrushAttribute { ANIM OFF ; }
				BOOL edg_UseTabletPressureAttribute { ANIM OFF ; }
				
				BOOL edg_AffectSelectedOnlyAttribute { ANIM OFF ; }
				BOOL edg_AffectByRootsOnlyAttribute { ANIM OFF ; }
				
				BOOL edg_RespectVertexWeightsAttribute { ANIM OFF ; }
				BOOL edg_PreserveStrandLengthAttribute { ANIM OFF ; }
				
				BOOL edg_OptimizeStrandGeometryAttribute { ANIM OFF ; }
				BOOL edg_ResampleStrandsAttribute { ANIM OFF ; }
			}
			
			SEPARATOR { LINE; }
			
			LONG edg_BrushMirrorAxisAttribute
			{
				ANIM OFF;
				CYCLE
				{
					edg_BrushMirrorAxis_Count;
					edg_BrushMirrorAxis_X;
					edg_BrushMirrorAxis_Y;
					edg_BrushMirrorAxis_Z;
					
				};
			}
			
			BOOL edg_MirrorBrushInWorldSpaceAttribute { ANIM OFF ; }
			
			SEPARATOR { LINE; }
			
			GROUP edg_BrushAttenuationRamps_Group
			{
				DEFAULT 1;
				
				SPLINE edg_BrushStrengthAttenuationRampAttribute { ANIM OFF ; }
				
				SPLINE edg_StrandStrengthAttenuationRampAttribute { ANIM OFF ; }
			}
		}
		
		SEPARATOR { LINE; }
		
		GROUP edg_PLUGS
		{
		}

		LONG_ARRAY edg_BrushShape_Array {}
		LONG_ARRAY edg_BrushSize_Array {}
		REAL_ARRAY edg_BrushStrength_Array {}
		BOOL_ARRAY edg_AffectSelectedOnly_Array {}
		BOOL_ARRAY edg_AffectByRootsOnly_Array {}
		BOOL_ARRAY edg_RespectVertexWeights_Array {}
		BOOL_ARRAY edg_UseSurfaceBrush_Array {}
		SPLINE_ARRAY edg_BrushStrengthAttenuationRamp_Array {}
		SPLINE_ARRAY edg_StrandStrengthAttenuationRamp_Array {}

		GUIDESDELTADATA edg_InputGuidesDeltaAttribute {}
		
		GUIDESDELTADATA edg_OutputGuidesDeltaAttribute {}
		
		HAIRDATA edg_CachedGuidesAttribute {}
		
	}
	
	// Groups
	
	// Strand groups:
	
	GROUP edg_StrandGroups_Group
	{
		DEFAULT 1;
		
		BOOL edg_UseStrandGroupsAttribute
		{
			ANIM OFF;
		}
		
		LONG edg_CurrentStrandGroupIndexAttribute
		{
			CUSTOMGUI LONGSLIDER;
			MIN 0;
			MAX 100;
			MAXSLIDER 10;
			ANIM OFF;
		}
		
		GROUP
		{
			COLUMNS 2;
			
			BUTTON edg_Button_StrandGroups_Assign {}
			BUTTON edg_Button_StrandGroups_Select {}
		}
		GROUP
		{
			COLUMNS 1;
			
			BUTTON edg_Button_StrandGroups_AssignUnique {}
		}
		
		GROUP edg_SelectByOrderLabel
		{
			DEFAULT 1;
			COLUMNS 2;
			
			BUTTON edg_Button_StrandGroups_SelectPrevious {}
			BUTTON edg_Button_StrandGroups_SelectNext {}
		}
		
		BOOL edg_SelectByGroupAttribute
		{
			ANIM OFF;
		}
	}
	
	// Channels
	
	GROUP edg_Channels_Group
	{
		DEFAULT 1;
		
		GROUP
		{
			STATICTEXT edg_Button_Channels_Label {}
		}
		
		REAL edg_CurrentChannelValueAttribute
		{
			CUSTOMGUI REALSLIDER;
			MIN 0.0;
			MAXSLIDER 1.0;
			STEP 0.01;
			ANIM OFF;
		}
		
		LONG edg_CurrentChannelIdAttribute
		{
			CUSTOMGUI LONGLIST;
			ANIM OFF;
		}
		
		GROUP
		{
			COLUMNS 3;
			
			BUTTON edg_Button_Channels_Add {}
			BUTTON edg_Button_Channels_Delete {}
			BUTTON edg_Button_Channels_Rename {}
		}

		SEPARATOR { LINE; }

		GROUP
		{
			COLUMNS 3;
			
			BUTTON edg_Button_Channels_SetValue {}
			BUTTON edg_Button_Channels_DeselectAll {}
		}
	}

	INCLUDE OBakeableInterface;
}
